<?php

# getsubdirs.php
#
# Server-side script for file browser object. When passed a
# directory name (as a GET argument called "dir"), it will
# return all subdirectories of that directory, in XML format.
# The directory is assumed to be relative to $Base_Dir, which
# in turn is relative to the server's DOCUMENT_ROOT. (Exception:
# if $Base_Dir starts with /~, it will be expanded to a user's
# web dir, assumed to be /home/username/public_html.)

# Directories with names beginning with a dot (period) will
# automatically be omitted from display.

# ----------------- configuration variables --------------------

# Configure this variable as the top-level directory, above
# which no information will be returned. Just use '/' to set
# it equal to DOCUMENT_ROOT.
#
$Base_Dir = '/~kmactane';

# List any directory names you want to hide here. Any directory
# whose name is included in this array, regardless of its level,
# will be omitted from display.
#
$Hide_Names = array(
	'hidden',
	'secret',
);

# This array works like the $Hide_Names array, above, except
# with regexes. For example, including '/^hide_/i' as an array
# element will omit any directory from display whose name
# begins with "hide_", "Hide_", "HIDE_", and so on. of course,
# this is more processor-intensive; leave it empty if you wish.
#
$Hide_Patterns = array(
	"/^hide_/i",
	"/secret/i",
);

# -------------------  end configuration  ----------------------

$dir_requested = $_GET['dir'];
$doc_root = $_SERVER['DOCUMENT_ROOT'];

if (substr($Base_Dir, 0, 1) != '/') {
	$Base_Dir = '/'.$Base_Dir;
}

if (preg_match("/^\/~([^\/]+)(\/.*)?$/", $Base_Dir, $matches)) {
	$Base_Dir = '/home/'.$matches[1].'/public_html'.$matches[2];
	$doc_root = '/home/'.$matches[1].'/public_html';
}

if (strpos($doc_root, $Base_Dir) === 0 && strlen($doc_root) > strlen($Base_Dir)) {
	$Base_Dir = $doc_root;
}

$dir_requested = $Base_Dir . '/' . $dir_requested;

header("Content-type: text/xml");

print "<?xml version=\"1.0\" standalone=\"yes\"?>\n\n";
print "<dirs>\n";
$dir_list = array();
$dh = @opendir($dir_requested);
while (($file = readdir($dh)) !== false) {
	if (substr($file, 0, 1) == '.') {
		continue;
	}
	foreach ($Hide_Names as $name) {
		if ($file == $name) {
			continue 2;
		}
	}
	foreach ($Hide_Patterns as $pattern) {
		if (preg_match($pattern, $file)) {
			continue 2;
		}
	}
	if (is_dir($dir_requested.'/'.$file)) {
		array_push($dir_list, $file);
	}
}
closedir($dh);
natcasesort($dir_list);
reset($dir_list);
foreach ($dir_list as $one_dir) {
	print "\t<dir>$one_dir</dir>\n";
}

print "</dirs>\n\n\n\n";

exit;




?>

