
/* libdirbrowser.js
 *
 * Library of functions needed for the AJAX dirbrowser item.
 */


// -----------  Global variable declarations  ------------------
// --------  Change as needed if you want to tweak  ------------
// -----------  the file browser's operation.  -----------------

// What's the base directory to start in? (Note that this is
// relative to the $base_dir configured in getsubdirs.php
var Base_Dir = '/';

// What's the URL to query for subdirectory information? This may
// be absolute or relative, but should point to the getsubdirs.php
// script in some way or another.
var Query_URL = '/getsubdirs.php';

// How wide are your folder images, in pixels? (You may want
// to add a couple of extra pixels for spacing; it won't
// distort the images.)
var Img_Width = 18;

// How many spaces do you want to use for each indent level?
var Num_Spaces = 5;

// What's the local URL for the open folder image?
var Folder_Open = '/icons/folder-open.gif';

// And the URL for the closed folder image?
var Folder_Closed = '/icons/folder-closed.gif';

// What text to use to show an open folder?
var Text_Open = "(-) ";

// And what text to use for a closed folder?
var Text_Closed = '(+) ';


// ----------------  End global declarations.  -----------------


// Define our XMLHttpRequest object, "xhobj", in the global scope.
var xhobj = get_XH_obj();

// Also define a global id number to be passed to the event handler.
var global_id;

// And a global click counter variable. This will increment on
// every user click, and be used to ensure the uniqueness of
// option element IDs.
var click_count = 0;

// Make sure these variables get treated as integers, rather
// than strings. (We need them to be added, not concatenated!)
Img_Width = parseInt(Img_Width);
Num_Spaces = parseInt(Num_Spaces);

// -------------------------------------------------------------
// ---------  Begin functions, in alphabetical order  ----------
// -------------------------------------------------------------


function add_dirs() {
	// Event handler for XMLHttpRequest object, triggered by
	// readyStateChange event. Collects subdirectory list
	// returned by server, and inserts it all after the OPTION
	// with the global_id that was set before the event handler
	// call in open_item().
	
	var level = parseInt(get_level(global_id)) + 1;
	var lead_dir = document.getElementById(global_id).value;
	while (lead_dir.substr(-1) == '/') {
		lead_dir = lead_dir.substring(0, lead_dir.length - 1);
	}
	if (xhobj.readyState == 4) {
		var stat = xhobj.status;
		var stat_text = xhobj.statusText;
		var resp_xml = xhobj.responseXML;
		var dir_list = resp_xml.getElementsByTagName("dir");
		
		// Set up a blank array to hold the actual OPTION tags
		// that will be inserted into the SELECT box.
		var opt_list = new Array();
		// Now insert them, in reverse order. (That way, the
		// index we're inserting after remains constant.)
		for (i = dir_list.length - 1; i >= 0; i--) {
			var dirname = dir_list[i].firstChild.nodeValue;
			var opt_val = lead_dir + '/' + dirname;
			create_new_item(global_id, opt_val);
		}
		document.getElementById(global_id).scrollIntoView();
	}
}


// -------------------------------------------------------------

function can_indent_options() {
	// Returns a Boolean describing whether the user's browser
	// can use the CSS padding-left or margin-left property
	// to "indent" <option> tags.
	if (navigator.userAgent.indexOf('like Gecko') != -1) {
		return false;
	}
	if (navigator.userAgent.indexOf('Gecko') != -1) {
		return true;
	}
	return false;
}

// -------------------------------------------------------------

function can_show_images() {
	// Returns a Boolean describing whether the user's browser
	// can display CSS background-images in <option> tags.
	if (navigator.userAgent.indexOf('like Gecko') != -1) {
		return false;
	}
	if (navigator.userAgent.indexOf('Gecko') != -1) {
		return true;
	}
	return false;
}


// -------------------------------------------------------------

function close_item(id) {
	// Removes the given directory's subdirs from view and switches
	// its display settings to "closed" status.
	
	// First remove all subdirectories. Start by getting the item's 
	// index in the SELECT box, and a reference to the box itself.
	var idx = document.getElementById(id).index;
	idx++;
	var select_box = document.getElementById(id).parentNode;
	
	// Check the element's level.
	level = get_level(id);
	
	// Now, just remove elements until the level is the same.
	// Or until they're all gone, if this was at the bottom
	// of the list box.
	if (idx < select_box.options.length) {
		while (get_level(select_box.options[idx].id) > level) {
			select_box.remove(idx);
			if (idx >= select_box.options.length) {
				break;
			}
		}
	}
	
	// Then change the styling on the OPTION element to make it
	// appear closed.
	if (can_indent_options() && can_show_images()) {
		// This part is easy. just tweak the element's CSS properties.
		document.getElementById(id).style.backgroundImage = "url('" + Folder_Closed +"')";
	} else {
		// Replace Text_Closed with Text_Open.
		if (navigator.userAgent.indexOf('Opera') != -1) {
			var chunks = document.getElementById(id).innerHTML.split(Text_Open);
			document.getElementById(id).innerHTML = chunks.join(Text_Closed);
		} else {
			var chunks = document.getElementById(id).text.split(Text_Open);
			document.getElementById(id).text = chunks.join(Text_Closed);
		}
	}
	document.getElementById(id).className = 'closed';
}



// -------------------------------------------------------------

function create_new_item(after_id, opt_value) {
	// Adds a new OPTION to the SELECT list, right after the
	// given after_id. Takes opt_value to be the option's
	// VALUE attribute, and determines everything else based
	// on that and the after_id. (Naturally, new folders are
	// in "closed" state.)
	
	// If the after_id passed belongs to a SELECT box instead
	// of an OPTION element, this function will assume that
	// box is empty, and this is the first item being placed
	// in it.
	
	// Returns the id assigned to the new element on success.
	
	var level;
	if (document.getElementById(after_id).type != undefined &&
		document.getElementById(after_id).type.indexOf('select') != -1) {
		level = 0;
	} else {
		level = parseInt(get_level(after_id)) + 1;
	}
	var opt_text = opt_value.split('/').pop();
	if (opt_value.length < 1) {
		opt_value = '/';
		opt_text = '(root directory)';
	}
	var opt_id = id_escape(opt_text + ':' + click_count + ':' + level);

	// Create the new element and start filling in its properties.
	var this_opt = document.createElement('option');
	this_opt.id = opt_id;
	this_opt.value = opt_value;
	this_opt.className = 'closed';
	
	// If the browser can handle it, use CSS images and positioning;
	// otherwise, just use spaces and ASCII.
	if (can_indent_options()) {
		if (can_show_images()) {
			this_opt.style.marginLeft = Img_Width * level + "px";
			this_opt.style.backgroundImage = "url('" + Folder_Closed + "')";
			this_opt.style.backgroundPosition = "0% 65%";
			this_opt.style.backgroundRepeat = 'no-repeat';
			this_opt.style.paddingLeft = Img_Width + "px";
		} else {
			this_opt.style.marginLeft = Img_Width * level + "px";
			opt_text = Text_Closed + opt_text;
		}
	} else {
		var leading_space = '';
		for (var i = 0; i < level; i++) {
			for (var n = 0; n < Num_Spaces; n++) {
				if (navigator.userAgent.indexOf('Opera') != -1) {
					leading_space += '&nbsp;';
				} else if (navigator.userAgent.indexOf('Safari') != -1) {
					leading_space += '&nbsp;';
				} else {
					leading_space += ' ';
				}
			}
		}
		opt_text = leading_space + Text_Closed + opt_text;
	}
	if (navigator.userAgent.indexOf('Opera') != -1) {
		this_opt.innerHTML = opt_text;
	} else if (navigator.userAgent.indexOf('Safari') != -1) {
		this_opt.innerHTML = opt_text;
	} else {
		this_opt.text = opt_text;
	}

	// Get the item's index in the SELECT box. Then increment,
	// because select.add() wants to add *before* the specified
	// option.
	if (document.getElementById(after_id).type != undefined &&
		document.getElementById(after_id).type.indexOf('select') != -1) {
		try {
			// W3C style; may not work on IE
			document.getElementById(after_id).add(this_opt, null);
		} catch(err) {
			document.getElementById(after_id).add(this_opt);
		}
	} else {
		var idx = document.getElementById(after_id).index;
		idx++;
		var select_box = document.getElementById(after_id).parentNode;
		var ins_before = select_box.options[idx];
	
		try {
			// W3C style; may not work on IE
			select_box.add(this_opt, ins_before);
		} catch(err) {
			select_box.add(this_opt, idx);
		}
	}
	return opt_id;
}


// -------------------------------------------------------------


function dirbrowser_init(s_id) {
	// Sets up the initial directory display in a blank
	// SELECT element whose ID is given in s_id.
	
	var first_text = Base_Dir.split('/').pop();
	var first_id = create_new_item(s_id, first_text);
	toggle_item(first_id);
}


// -------------------------------------------------------------

function get_level(id) {
	// Extracts an OPTION element's level from its ID.
	return id.split('_3A').pop();
}

// -------------------------------------------------------------

function get_XH_obj() {
	// Standard function to return an XMLHttpRequest object
	// on both Gecko-based and MS browsers (and hopefully
	// all other kinds, too).
	var xhreq;
	if (window.XMLHttpRequest) {
		xhreq = new XMLHttpRequest();
	} else if (window.ActiveXObject) {
		xhreq = new ActiveXObject("Microsoft.XMLHTTP");
	} else {
		alert("I'm sorry, your browser doesn't seem to support the XMLHttpRequest object, either as part of the W3C DOM or as an ActiveX object. I regret to say that this means you won't be able to use the features on this site.");
	}
	return xhreq;
}



// -------------------------------------------------------------

function id_escape(text) {
	// Escapes the supplied string so that it will be acceptable
	// as an HTML ID attribute. Leaves A-Z, a-z and 0-9 unchanged;
	// all other characters are converted to an underscore (_)
	// followed by the character's ASCII value in hex. Example:
	// "foo+bar" becomes "foo_2Bbar", while "some text" becomes 
	// "some_20text".
	
	var escaped = '';
	var index = 0;
	var re = /[A-Za-z0-9]/;
	while (index < text.length) {
		var working = text.substr(index, 1);
		if (working.search(re) == -1) {
			char_code = working.charCodeAt(0).toString(16).toUpperCase();
			working = '_' + char_code;
		}
		escaped += working;
		index++;
	}
	return escaped;
}


// -------------------------------------------------------------

function open_item(id) {
	// Opens a directory and fills in the next-level directories.
	// Makes AJAX request to server-side script, and sets up
	// event handler that listens for the list of subdirectories 
	// coming back from the server.
	
	var dir_name = document.getElementById(id).value;
	xhobj.open("GET", Query_URL + "?dir=" + dir_name, true);
	
	// The add_dirs() routine will catch the returned subdir
	// list, and take care of actually splicing them into the
	// SELECT box. Set the global_id variable so add_dirs()
	// knows what id to append after.
	global_id = id;
	xhobj.onreadystatechange = add_dirs;
	xhobj.send(null);
	
	// Change the styling on the OPTION element to make it
	// appear open.
	if (can_indent_options() && can_show_images()) {
		// This part is easy. just tweak the element's CSS properties.
		document.getElementById(id).style.backgroundImage = "url('" + Folder_Open +"')";
	} else {
		// Replace Text_Closed with Text_Open.
		if (navigator.userAgent.indexOf('Opera') != -1) {
			var chunks = document.getElementById(id).innerHTML.split(Text_Closed);
			document.getElementById(id).innerHTML = chunks.join(Text_Open);
		} else {
			var chunks = document.getElementById(id).text.split(Text_Closed);
			document.getElementById(id).text = chunks.join(Text_Open);
		}
	}
	document.getElementById(id).className = 'open';
}
	


// -------------------------------------------------------------

function toggle_item(id) {
	
	// Top-level function that handles toggling the specified
	// item from open to closed or from closed to open.
	
	click_count++;
	
	if (! document.getElementById(id)) {
		return false;
	}
	if (document.getElementById(id).className == 'open') {
		close_item(id);
	} else {
		open_item(id);
	}
}


// -------------------------------------------------------------
// ------------  End functions, end library file.  -------------
// -------------------------------------------------------------



